<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

defined( '_JEXEC' ) or die;

use JchOptimize\Core\Admin\Icons;
use JchOptimize\Core\Admin\Tasks;
use Joomla\CMS\MVC\Controller\BaseController;

include_once dirname( __FILE__ ) . '/controller.php';

class JFormFieldControllerapi2utilities extends JFormFieldController
{

	protected $type = 'controllerutilities';

	public function __construct( $form = null )
	{
		parent::__construct( $form );

		switch ( JFactory::getApplication()->input->get( 'jchtask' ) )
		{
			case 'restoreimages':
				$this->restoreImages();;
				break;
			case 'deletebackups':
				$this->deleteBackups();
				break;
			default:
				break;
		}
	}

	/**
	 *
	 */
	public static function restoreImages()
	{
		$oController = new BaseController();
		$mResult     = Tasks::restoreBackupImages();

		if ( $mResult === 'SOMEIMAGESDIDNTRESTORE' )
		{
			$oController->setMessage( JText::_( 'JCH_SOMERESTOREIMAGE_FAILED' ), 'warning' );
		}
		elseif ( $mResult === 'BACKUPPATHDOESNTEXIST' )
		{
			$oController->setMessage( JText::_( 'JCH_BACKUPPATH_DOESNT_EXIST' ), 'warning' );
		}
		else
		{
			$oController->setMessage( JText::_( 'JCH_RESTOREIMAGE_SUCCESS' ) );
		}

		self::display( $oController );
	}

	/**
	 *
	 */
	public static function deleteBackups()
	{
		$oController = new BaseController();
		$mResult     = Tasks::deleteBackupImages();

		if ( $mResult === false )
		{
			$oController->setMessage( JText::_( 'JCH_DELETEBACKUPS_FAILED' ), 'error' );
		}
		elseif ( $mResult === 'BACKUPPATHDOESNTEXIST' )
		{
			$oController->setMessage( JText::_( 'JCH_BACKUPPATH_DOESNT_EXIST' ), 'warning' );
		}
		else
		{
			$oController->setMessage( JText::_( 'JCH_DELETEBACKUPS_SUCCESS' ) );
		}

		self::display( $oController );
	}

	protected function getButtons()
	{
		return Icons::getApi2UtilitiesIcons();
	}
}


