<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/core
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace JchOptimize\Core\Admin;

use JchOptimize\Platform\Paths;
use JchOptimize\Platform\Utility;

defined( '_JEXEC' ) or die( 'Restricted access' );

class Icons
{

	/**
	 *
	 * @param   array  $aButtons
	 *
	 * @return string
	 */
	public static function generateIcons( $aButtons )
	{
		$sField = '<div class="container-icons clearfix">';

		foreach ( $aButtons as $sButton )
		{
			$tooltip = isset( $sButton['tooltip'] ) ? 'class="hasTooltip" title="' . $sButton['tooltip'] . '"' : '';
			$sField  .= <<<JFIELD
<div class="icon {$sButton['class']}">
        <a class="btn" href="{$sButton['link']}"  {$sButton['script']}  >
                <div style="text-align: center;">
                        <i class="fa {$sButton['icon']} fa-3x" style="margin: 7px 0; color: {$sButton['color']}"></i>
                </div>
                <label {$tooltip}>
                        {$sButton['text']}
                </label><br>
                <i id="toggle" class="fa"></i>
        </a>
</div>
JFIELD;
		}

		$sField .= '</div>';

		return $sField;
	}

	/**
	 *
	 * @return array
	 */
	public static function getSettingsIcons()
	{
		$aButtons = array();

		$aButtons[0]['link']   = '';
		$aButtons[0]['icon']   = 'fa-wrench';
		$aButtons[0]['text']   = 'Minimum';
		$aButtons[0]['color']  = '#FFA319';
		$aButtons[0]['script'] = 'onclick="applyAutoSettings(1, 0); return false;"';
		$aButtons[0]['class']  = 'enabled settings-1';

		$aButtons[1]['link']   = '';
		$aButtons[1]['icon']   = 'fa-cog';
		$aButtons[1]['text']   = 'Intermediate';
		$aButtons[1]['color']  = '#FF32C7';
		$aButtons[1]['script'] = 'onclick="applyAutoSettings(2, 0); return false;"';
		$aButtons[1]['class']  = 'enabled settings-2';

		$aButtons[2]['link']   = '';
		$aButtons[2]['icon']   = 'fa-cogs';
		$aButtons[2]['text']   = 'Average';
		$aButtons[2]['color']  = '#CE3813';
		$aButtons[2]['script'] = 'onclick="applyAutoSettings(3, 0); return false;"';
		$aButtons[2]['class']  = 'enabled settings-3';

		$aButtons[3]['link']   = '';
		$aButtons[3]['icon']   = 'fa-forward';
		$aButtons[3]['text']   = 'Deluxe';
		$aButtons[3]['color']  = '#E8CE0B';
		$aButtons[3]['script'] = 'onclick="applyAutoSettings(4, 2); return false;"';
		$aButtons[3]['class']  = 'enabled settings-4';

		$aButtons[4]['link']   = '';
		$aButtons[4]['icon']   = 'fa-fast-forward';
		$aButtons[4]['text']   = 'Premium';
		$aButtons[4]['color']  = '#9995FF';
		$aButtons[4]['script'] = 'onclick="applyAutoSettings(5, 1); return false;"';
		$aButtons[4]['class']  = 'enabled settings-5';

		$aButtons[5]['link']   = '';
		$aButtons[5]['icon']   = 'fa-dashboard';
		$aButtons[5]['text']   = 'Optimum';
		$aButtons[5]['color']  = '#60AF2C';
		$aButtons[5]['script'] = 'onclick="applyAutoSettings(6, 1); return false;"';
		$aButtons[5]['class']  = 'enabled settings-6';

		return $aButtons;
	}

	/**
	 *
	 * @return array
	 */
	public static function getUtilityIcons()
	{
		$aButtons = array();

		$aButtons[1]['link']    = Paths::adminController( 'browsercaching' );
		$aButtons[1]['icon']    = 'fa-globe';
		$aButtons[1]['color']   = '#51A351';
		$aButtons[1]['text']    = Utility::translate( 'Optimize .htaccess' );
		$aButtons[1]['script']  = '';
		$aButtons[1]['class']   = 'enabled';
		$aButtons[1]['tooltip'] = Utility::translate( 'Use this button to add codes to your htaccess file to enable leverage browser caching and gzip compression.' );

		$aButtons[3]['link']    = Paths::adminController( 'filepermissions' );
		$aButtons[3]['icon']    = 'fa-file-text';
		$aButtons[3]['color']   = '#166BEC';
		$aButtons[3]['text']    = Utility::translate( 'Fix file permissions' );
		$aButtons[3]['script']  = '';
		$aButtons[3]['class']   = 'enabled';
		$aButtons[3]['tooltip'] = Utility::translate( 'If your site has lost CSS formatting after enabling the plugin, the problem could be that the plugin files were installed with incorrect file permissions so the browser cannot access the cached combined file. Click here to correct the plugin\'s file permissions.' );

		$aButtons[5]['link']    = Paths::adminController( 'cleancache' );
		$aButtons[5]['icon']    = 'fa-times-circle';
		$aButtons[5]['color']   = '#C0110A';
		$aButtons[5]['text']    = Utility::translate( 'Clean Cache' );
		$aButtons[5]['script']  = '';
		$aButtons[5]['class']   = 'enabled';
		$aButtons[5]['tooltip'] = Utility::translate( 'Click this button to clean the plugin\'s cache and page cache. If you have edited any CSS or javascript files you need to clean the cache so the changes can be visible.' );

		return $aButtons;
	}

	public static function getApi2UtilitiesIcons()
	{
		$aButtons = array();

		$aButtons[0]['link']    = Paths::adminController( 'restoreimages' );
		$aButtons[0]['icon']    = 'fa-undo';
		$aButtons[0]['color']   = '#51A351';
		$aButtons[0]['text']    = Utility::translate( 'Restore original images' );
		$aButtons[0]['script']  = '';
		$aButtons[0]['class']   = 'enabled';
		$aButtons[0]['tooltip'] = Utility::translate( 'If you\'re not satisfied with the images that were optimized you can restore the original ones by clicking this button if they were not deleted.' );

		$aButtons[1]['link']    = Paths::adminController( 'deletebackups' );
		$aButtons[1]['icon']    = 'fa-trash';
		$aButtons[1]['color']   = '#166BEC';
		$aButtons[1]['text']    = Utility::translate( 'Delete backup images' );
		$aButtons[1]['script']  = '';
		$aButtons[1]['class']   = 'enabled';
		$aButtons[1]['tooltip'] = Utility::translate( 'This will permanently delete the images that were backed up. There\'s no way to undo this so be sure you\'re satisfied with the ones that were optimized.' );

		return $aButtons;
	}
	/**
	 * @deprecated Use JchOptimize\Core\Admin\Tasks::leverageBrowserCaching instead
	 * @return string
	 */
	public static function leverageBrowserCaching()
	{
		$htaccess = Paths::rootPath() . '/.htaccess';

		if ( file_exists( $htaccess ) )
		{
			$contents = file_get_contents( $htaccess );

			if ( ! preg_match( '@\n?## BEGIN EXPIRES CACHING - JCH OPTIMIZE ##.*?## END EXPIRES CACHING - JCH OPTIMIZE ##@s', $contents ) )
			{
				$sExpires = <<<APACHECONFIG


## BEGIN EXPIRES CACHING - JCH OPTIMIZE ##
<IfModule mod_expires.c>
	ExpiresActive on

	# Perhaps better to whitelist expires rules? Perhaps.
	ExpiresDefault "access plus 1 year"

	# cache.appcache needs re-requests in FF 3.6 (thanks Remy ~Introducing HTML5)
	ExpiresByType text/cache-manifest "access plus 0 seconds"

	# Your document html
	ExpiresByType text/html "access plus 0 seconds"

	# Data
	ExpiresByType text/xml "access plus 0 seconds"
	ExpiresByType application/xml "access plus 0 seconds"
	ExpiresByType application/json "access plus 0 seconds"

	# Feed
	ExpiresByType application/rss+xml "access plus 1 hour"
	ExpiresByType application/atom+xml "access plus 1 hour"

	# Favicon (cannot be renamed)
	ExpiresByType image/x-icon "access plus 1 week"

	# Media: images, video, audio
	ExpiresByType image/gif "access plus 1 year"
	ExpiresByType image/png "access plus 1 year"
	ExpiresByType image/jpg "access plus 1 year"
	ExpiresByType image/jpeg "access plus 1 year"
	ExpiresByType image/webp "access plus 1 year"
	ExpiresByType audio/ogg "access plus 1 year"
	ExpiresByType video/ogg "access plus 1 year"
	ExpiresByType video/mp4 "access plus 1 year"
	ExpiresByType video/webm "access plus 1 year"

	# HTC files (css3pie)
	ExpiresByType text/x-component "access plus 1 year"

	# Webfonts
	ExpiresByType application/font-ttf "access plus 1 year"
	ExpiresByType font/* "access plus 1 year"
	ExpiresByType application/font-woff "access plus 1 year"
	ExpiresByType application/font-woff2 "access plus 1 year"
	ExpiresByType image/svg+xml "access plus 1 year"
	ExpiresByType application/vnd.ms-fontobject "access plus 1 year"

	# CSS and JavaScript
	ExpiresByType text/css "access plus 1 year"
	ExpiresByType type/javascript "access plus 1 year"
	ExpiresByType application/javascript "access plus 1 year"

	<IfModule mod_headers.c>
		Header append Cache-Control "public"
		<FilesMatch ".(js|css|xml|gz|html)$">
			Header append Vary: Accept-Encoding
		</FilesMatch>
	</IfModule>

</IfModule>

<IfModule mod_deflate.c>
	AddOutputFilterByType DEFLATE text/html
	AddOutputFilterByType DEFLATE text/css
	AddOutputFilterByType DEFLATE text/javascript
	AddOutputFilterByType DEFLATE text/xml
	AddOutputFilterByType DEFLATE text/plain
	AddOutputFilterByType DEFLATE image/x-icon
	AddOutputFilterByType DEFLATE image/svg+xml
	AddOutputFilterByType DEFLATE application/rss+xml
	AddOutputFilterByType DEFLATE application/javascript
	AddOutputFilterByType DEFLATE application/x-javascript
	AddOutputFilterByType DEFLATE application/xml
	AddOutputFilterByType DEFLATE application/xhtml+xml
	AddOutputFilterByType DEFLATE application/font
	AddOutputFilterByType DEFLATE application/font-truetype
	AddOutputFilterByType DEFLATE application/font-ttf
	AddOutputFilterByType DEFLATE application/font-otf
	AddOutputFilterByType DEFLATE application/font-opentype
	AddOutputFilterByType DEFLATE application/font-woff
	AddOutputFilterByType DEFLATE application/font-woff2
	AddOutputFilterByType DEFLATE application/vnd.ms-fontobject
	AddOutputFilterByType DEFLATE font/ttf
	AddOutputFilterByType DEFLATE font/otf
	AddOutputFilterByType DEFLATE font/opentype
	AddOutputFilterByType DEFLATE font/woff
	AddOutputFilterByType DEFLATE font/woff2

</IfModule>
## END EXPIRES CACHING - JCH OPTIMIZE ##

APACHECONFIG;

				$sExpires = str_replace( array( "\r\n", "\n" ), PHP_EOL, $sExpires );

				return file_put_contents( $htaccess, $sExpires, FILE_APPEND );
			}
			else
			{
				return 'CODEALREADYINFILE';
			}
		}
		else
		{
			return 'FILEDOESNTEXIST';
		}
	}

	/**
	 * @deprecated Use \JchOptimize\Core\Admin\Tasks instead
	 */
	public static function cleanHtaccess()
	{
		$htaccess = Paths::rootPath() . '/.htaccess';

		if ( file_exists( $htaccess ) )
		{
			$contents = file_get_contents( $htaccess );
			$regex    = '@\n?## BEGIN EXPIRES CACHING - JCH OPTIMIZE ##.*?## END EXPIRES CACHING - JCH OPTIMIZE ##@s';

			$clean_contents = preg_replace( $regex, '', $contents, - 1, $count );

			if ( $count > 0 )
			{
				file_put_contents( $htaccess, $clean_contents );
			}
		}
	}

}