<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

defined( '_JEXEC' ) or die;

use JchOptimize\Platform\Utility;

include_once dirname( __FILE__ ) . '/controller.php';

class JFormFieldControllerapi2optimizeimages extends JFormFieldController
{

	public $type = 'controllerapi2optimizeimages';

	/**
	 *
	 * @return string
	 */
	protected function getInput()
	{
		$curl_enabled = function_exists( 'curl_version' ) && curl_version();
		// $allow_url_fopen = (bool) ini_get('allow_url_fopen');

		if ( $curl_enabled )// && $allow_url_fopen)
		{
			$field = '<div id="api2-optimize-images-container" >';
			$field .= parent::getInput();
			$field .= '<div style="clear:both"></div>';
			$field .= '</div>';
		}
		else
		{
			$header = JText::_( 'Error' );
			//$message = !$allow_url_fopen ? JText::_('JCH_OPTIMIZE_IMAGE_NO_URL_FOPEN_MESSAGE') : '';
			$message = ! $curl_enabled ? JText::_( 'JCH_OPTIMIZE_IMAGE_NO_CURL_MESSAGE' ) : $message;

			$field = '<dl id="system-message">
					<dt class="message">' . $header . '</dt>
					<dd class="message warning">
					<ul>
					<li>' . $message . '</li>
					</ul>
					</dd>
					</dl>';

		}

		return $field;
	}

	/**
	 *
	 * @return array
	 */
	protected function getButtons()
	{
		$page = JURI::getInstance()->toString() . '&jchtask=optimizeimages';

		$aButton              = array();
		$aButton[0]['link']   = '';
		$aButton[0]['icon']   = 'fa-magic';
		$aButton[0]['color']  = '#278EB1';
		$aButton[0]['text']   = Utility::translate( 'Optimize Images' );
		$aButton[0]['script'] = 'onclick="jchIOptimizeApi.optimizeImages(\'' . $page . '\', \'auto\'); return false;"';
		$aButton[0]['class']  = 'enabled';

		return $aButton;
	}

}


?>
